"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentsController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const payments_service_1 = require("./payments.service");
const create_payment_dto_1 = require("./dto/create-payment.dto");
const process_payment_dto_1 = require("./dto/process-payment.dto");
const refund_payment_dto_1 = require("./dto/refund-payment.dto");
const payment_response_dto_1 = require("./dto/payment-response.dto");
const jwt_auth_guard_1 = __importDefault(require("../../common/guards/jwt-auth.guard"));
const roles_guard_1 = __importDefault(require("../../common/guards/roles.guard"));
const roles_decorator_1 = require("../../common/decorators/roles.decorator");
let PaymentsController = class PaymentsController {
    paymentsService;
    constructor(paymentsService) {
        this.paymentsService = paymentsService;
    }
    async createPaymentIntent(req, createPaymentDto) {
        const customerId = req.user.customerId;
        return this.paymentsService.createPaymentIntent(createPaymentDto, customerId);
    }
    async processPayment(req, processPaymentDto) {
        const customerId = req.user.customerId;
        return this.paymentsService.processPayment(processPaymentDto, customerId);
    }
    async refundPayment(req, id, refundPaymentDto) {
        const customerId = req.user.role === 'admin' ? undefined : req.user.customerId;
        const { payment } = await this.paymentsService.refundPayment(id, refundPaymentDto, customerId);
        return {
            id: payment.id,
            orderId: payment.orderId,
            customerId: payment.customerId,
            amount: payment.amount,
            status: payment.status,
            createdAt: payment.createdAt,
            updatedAt: payment.updatedAt,
            method: payment.method,
            paymentGateway: payment.paymentGateway,
            isRefundable: payment.isRefundable,
        };
    }
    async getMyPayments(req) {
        const customerId = req.user.customerId;
        return this.paymentsService.getCustomerPayments(customerId);
    }
    async getAllPayments() {
        return this.paymentsService.getAllPayments();
    }
    async getStats() {
        return this.paymentsService.getPaymentStats();
    }
    async getPayment(id, req) {
        const customerId = req.user.role === 'admin' ? undefined : req.user.customerId;
        const payment = await this.paymentsService.getPayment(id, customerId);
        return {
            id: payment.id,
            orderId: payment.orderId,
            customerId: payment.customerId,
            amount: payment.amount,
            status: payment.status,
            createdAt: payment.createdAt,
            updatedAt: payment.updatedAt,
            method: payment.method,
            paymentGateway: payment.paymentGateway,
            isRefundable: payment.isRefundable,
        };
    }
};
exports.PaymentsController = PaymentsController;
__decorate([
    (0, common_1.Post)('create-intent'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.default),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create payment intent' }),
    (0, swagger_1.ApiResponse)({ status: 201, description: 'Payment intent created successfully', type: payment_response_dto_1.PaymentResponseDto }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Bad request' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Order not found' }),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, create_payment_dto_1.CreatePaymentDto]),
    __metadata("design:returntype", Promise)
], PaymentsController.prototype, "createPaymentIntent", null);
__decorate([
    (0, common_1.Post)('process'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.default),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Process payment' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Payment processed successfully', type: payment_response_dto_1.PaymentResponseDto }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Payment processing failed' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Payment not found' }),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, process_payment_dto_1.ProcessPaymentDto]),
    __metadata("design:returntype", Promise)
], PaymentsController.prototype, "processPayment", null);
__decorate([
    (0, common_1.Put)(':id/refund'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.default),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Refund a payment' }),
    (0, swagger_1.ApiParam)({ name: 'id', type: String, description: 'Payment ID' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Payment refunded successfully', type: payment_response_dto_1.PaymentResponseDto }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Refund failed' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Payment not found' }),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.Param)('id')),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String, refund_payment_dto_1.RefundPaymentDto]),
    __metadata("design:returntype", Promise)
], PaymentsController.prototype, "refundPayment", null);
__decorate([
    (0, common_1.Get)('my-payments'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.default),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Get customer payments' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Payments retrieved successfully', type: [payment_response_dto_1.PaymentResponseDto] }),
    __param(0, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PaymentsController.prototype, "getMyPayments", null);
__decorate([
    (0, common_1.Get)(),
    (0, common_1.UseGuards)(jwt_auth_guard_1.default, roles_guard_1.default),
    (0, roles_decorator_1.Roles)('admin'),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Get all payments - Admin only' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Payments retrieved successfully', type: [payment_response_dto_1.PaymentResponseDto] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PaymentsController.prototype, "getAllPayments", null);
__decorate([
    (0, common_1.Get)('stats'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.default, roles_guard_1.default),
    (0, roles_decorator_1.Roles)('admin'),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Get payment statistics - Admin only' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Statistics retrieved successfully' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PaymentsController.prototype, "getStats", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.default),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiOperation)({ summary: 'Get payment by ID' }),
    (0, swagger_1.ApiParam)({ name: 'id', type: String, description: 'Payment ID' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Payment retrieved successfully', type: payment_response_dto_1.PaymentResponseDto }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Payment not found' }),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], PaymentsController.prototype, "getPayment", null);
exports.PaymentsController = PaymentsController = __decorate([
    (0, swagger_1.ApiTags)('Payments'),
    (0, common_1.Controller)('payments'),
    __metadata("design:paramtypes", [payments_service_1.PaymentsService])
], PaymentsController);
//# sourceMappingURL=payments.controller.js.map